@echo off
setlocal enabledelayedexpansion

set "csvfile=search-replace-list.csv"
set "outputfolder=hasilbat"
set "commandsPerBatch=5"

if not exist "%outputfolder%" mkdir "%outputfolder%"

set "batchCount=1"
set /a lineCount=0

set "batfile=%outputfolder%\batch_!batchCount!.bat"
> "%batfile%" echo @echo off

for /f "usebackq skip=1 tokens=1,2,3 delims=," %%A in ("%csvfile%") do (
    set /a lineCount+=1

    set "folderPath=%%A"
    set "search=%%B"
    set "replace=%%C"
    set "command="D:\fnr.exe" --cl --dir "C:\laragon\www\gcloud\content\!folderPath!" --fileMask "*.html, *.xml" --excludeFileMask "*.dll, *.exe" --includeSubDirectories --find "!search!" --replace "!replace!""

    >> "%outputfolder%\batch_!batchCount!.bat" echo !command!

    if !lineCount! geq %commandsPerBatch% (
        set /a batchCount+=1
        set /a lineCount=0
        set "batfile=%outputfolder%\batch_!batchCount!.bat"
        > "!batfile!" echo @echo off
    )
)

echo Selesai generate batch commands.
pause
