<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8'); ?></title>
  <meta name="description" content="<?php echo htmlspecialchars($description, ENT_QUOTES, 'UTF-8'); ?>">
  <?php if (!empty($canonicalUrl)): ?>
  <link rel="canonical" href="<?php echo htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8'); ?>">
  <?php endif; ?>
  <style>
    body { font-family: Arial, sans-serif; line-height: 1.6; max-width: <?php echo $config['settings']['container_max_width'] ?? '800px'; ?>; margin: 0 auto; padding: 20px; background: #f5f5f5; }
    .container { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    h1 { font-size: 28px; margin-bottom: 20px; color: #333; }
    nav { margin-bottom: 20px; padding-bottom: 10px; border-bottom: 1px solid #eee; }
    nav a { color: #0066cc; }
    img { max-width: 100%; height: auto; border-radius: 4px; margin: 10px 0; }
    .image-caption { font-size: 12px; color: #666; margin-bottom: 20px; }
    .related { margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; }
    .related h3 { font-size: 18px; margin-bottom: 10px; }
    .related ul { list-style: disc; padding-left: 20px; }
    .related a { color: #0066cc; }
  </style>
  <script type="application/ld+json"><?php echo json_encode($ldJson, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES); ?></script>
</head>
<body>
  <div class="container">
    <nav>
      <a href="./about-us.html">About Us</a>
    </nav>
    <h1><?php echo htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8'); ?></h1>
