<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?php echo htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8'); ?></title>
  <meta name="description" content="<?php echo htmlspecialchars($description, ENT_QUOTES, 'UTF-8'); ?>" />
  <?php if (!empty($canonicalUrl)): ?>
  <link rel="canonical" href="<?php echo htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8'); ?>" />
  <?php endif; ?>
  <?php foreach ($config['css'] as $css): ?>
  <link href="<?php echo $css; ?>" rel="stylesheet" />
  <?php endforeach; ?>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            primary: '#7c3aed',
            secondary: '#60a5fa',
            accent: '#a78bfa',
            background: '#f8fafc'
          },
          fontFamily: {
            sans: ['Inter', 'system-ui', 'sans-serif']
          }
        }
      }
    }
  </script>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');
    
    body {
      font-family: 'Inter', system-ui, sans-serif;
    }
    
    .gradient-bg {
      background: linear-gradient(135deg, #7c3aed 0%, #60a5fa 50%, #a78bfa 100%);
    }
    
    .card-shadow {
      box-shadow: 0 4px 6px -1px rgba(124, 58, 237, 0.1), 0 2px 4px -1px rgba(124, 58, 237, 0.06);
    }
    
    .text-gradient {
      background: linear-gradient(135deg, #7c3aed 0%, #60a5fa 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }
    
    .article-content p {
      margin-bottom: 1.25rem;
      line-height: 1.8;
    }
    
    .article-content img {
      border-radius: 0.75rem;
      margin: 1.5rem 0;
      box-shadow: 0 10px 15px -3px rgba(124, 58, 237, 0.15);
    }
    
    .related-link {
      transition: all 0.2s ease;
    }
    
    .related-link:hover {
      transform: translateX(4px);
    }
  </style>
  <?php if (!empty($inject['header'])): ?>
  <?php echo $inject['header']; ?>
  <?php endif; ?>
  <script type="application/ld+json"><?php echo json_encode($ldJson, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES); ?></script>
</head>
<body class="bg-background text-gray-800 antialiased">
  <!-- Header Gradient Bar -->
  <div class="gradient-bg h-2"></div>
  
  <!-- Main Container -->
  <div class="min-h-screen">
    <!-- Header Section -->
    <header class="bg-white border-b border-purple-100">
      <div class="max-w-<?php echo $config['settings']['container_max_width'] ?? '5xl'; ?> mx-auto px-4 py-6">
        <div class="flex items-center justify-between">
          <div class="text-2xl font-bold">
            <span class="text-gradient">Anggi</span>
            <span class="text-gray-400">Ideas</span>
          </div>
          <nav class="hidden md:flex space-x-6">
            <a href="./" class="text-gray-600 hover:text-primary transition-colors">Home</a>
            <a href="./about-us.html" class="text-gray-600 hover:text-primary transition-colors">About Us</a>
          </nav>
        </div>
      </div>
    </header>
    
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-purple-50 via-blue-50 to-purple-50 py-12">
      <div class="max-w-<?php echo $config['settings']['container_max_width'] ?? '5xl'; ?> mx-auto px-4">
        <h1 class="text-4xl md:text-5xl font-bold text-gray-900 mb-4 leading-tight">
          <span class="text-gradient"><?php echo htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8'); ?></span>
        </h1>
        <p class="text-gray-600 text-lg max-w-3xl">
          <?php echo htmlspecialchars($description, ENT_QUOTES, 'UTF-8'); ?>
        </p>
      </div>
    </section>
    
    <!-- Content Section -->
    <main class="max-w-<?php echo $config['settings']['container_max_width'] ?? '5xl'; ?> mx-auto px-4 py-10">
      <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
        <!-- Main Content -->
        <div class="lg:col-span-8">
          <article class="bg-white rounded-2xl card-shadow p-8">
            <!-- Featured Image -->
            <?php if (!empty($mainImage)): ?>
            <div class="mb-8">
              <img src="<?php echo htmlspecialchars($mainImage, ENT_QUOTES, 'UTF-8'); ?>" 
                   alt="<?php echo htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8'); ?>"
                   class="w-full h-auto rounded-xl shadow-lg"
                   loading="eager" />
            </div>
            <?php endif; ?>
            
            <!-- Article Content -->
            <div class="article-content text-gray-700 text-lg">
