<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?php echo htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8'); ?></title>
  <meta name="description" content="<?php echo htmlspecialchars($description, ENT_QUOTES, 'UTF-8'); ?>" />
  <?php if (!empty($canonicalUrl)): ?>
  <link rel="canonical" href="<?php echo htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8'); ?>" />
  <?php endif; ?>
  <?php foreach ($config['css'] as $css): ?>
  <link href="<?php echo $css; ?>" rel="stylesheet" />
  <?php endforeach; ?>
  <?php if (!empty($inject['header'])): ?>
  <?php echo $inject['header']; ?>
  <?php endif; ?>
  <script type="application/ld+json"><?php echo json_encode($ldJson, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES); ?></script>
</head>
<body class="bg-gray-100 text-gray-900 py-8">
  <div class="container mx-auto px-4 max-w-<?php echo $config['settings']['container_max_width'] ?? '6xl'; ?>">
    <nav class="mb-8 text-center">
      <a href="./about-us.html" class="text-blue-700 hover:underline">About Us</a>
    </nav>
    <h1 class="text-4xl font-bold mb-8 text-center"><?php echo htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8'); ?></h1>
    <div class="bg-white rounded-lg shadow-lg p-6 md:p-8">
