@echo off
chcp 65001 >nul
title PHP HTML Exporter

echo ========================================
echo PHP CLI HTML Exporter
echo ========================================
echo.

REM Default values
set SPLIT_SIZE=1000
set BASE_URL=domain.com
set TEMPLATE=mix
set VERBOSE=true

REM Parse arguments
:parse_args
if "%1"=="" goto :run_export
if "%1"=="--help" goto :show_help
if "%1"=="-h" goto :show_help
if "%1"=="--list" goto :list_templates
if "%1"=="--verbose" set VERBOSE=true& shift & goto :parse_args
if "%1"=="-v" set VERBOSE=true& shift & goto :parse_args

REM Check for --template= option
echo %1 | findstr /b "--template=" >nul
if %errorlevel% equ 0 (
    for /f "tokens=* delims=--template=" %%a in ("%1") do set TEMPLATE=%%a
    shift
    goto :parse_args
)

REM Check for -t= option
echo %1 | findstr /b "-t=" >nul
if %errorlevel% equ 0 (
    for /f "tokens=* delims=-t=" %%a in ("%1") do set TEMPLATE=%%a
    shift
    goto :parse_args
)

REM Check if numeric (splitSize) or baseUrl
echo %1 | findstr /r "^[0-9][0-9]*$" >nul
if %errorlevel% equ 0 (
    set SPLIT_SIZE=%1
) else (
    set BASE_URL=%1
)
shift
goto :parse_args

:show_help
echo Usage:
echo   php export_html.bat [splitSize] [baseUrl] [options]
echo.
echo Arguments:
echo   splitSize   Number of posts per folder (default: 50)
echo   baseUrl     Base URL for sitemap generation (optional)
echo.
echo Options:
echo   --template=^<name^>  Template to use (default: default)
echo   --verbose           Show detailed progress
echo   --help               Show this help message
echo   --list               List available templates
echo.
echo Examples:
echo   php export_html.bat 50 "https://example.com"
echo   php export_html.bat 100 "https://example.com" --template=default --verbose
echo.
echo Available Templates:
echo   default  - Tailwind CSS based template
echo   gallery  - Image-focused gallery layout
echo   simple   - Minimal HTML template
echo.
goto :end

:list_templates
echo.
echo Available Templates:
echo ====================
echo.
echo   default  - Tailwind CSS based template
echo   gallery  - Image-focused gallery layout
echo   simple   - Minimal HTML template
echo.
goto :end

:run_export
echo [INFO] Starting PHP HTML Exporter...
echo [INFO] Template: %TEMPLATE%
echo [INFO] Split size: %SPLIT_SIZE%
if not "%BASE_URL%"=="" echo [INFO] Base URL: %BASE_URL%
echo.

REM Run PHP export
php export_html.php %SPLIT_SIZE% "%BASE_URL%" --template=%TEMPLATE%
if %VERBOSE%==true php export_html.php %SPLIT_SIZE% "%BASE_URL%" --template=%TEMPLATE% --verbose

:end
pause
