<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?php echo htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8'); ?></title>
  <meta name="description" content="<?php echo htmlspecialchars($description, ENT_QUOTES, 'UTF-8'); ?>" />
  <?php if (!empty($canonicalUrl)): ?>
  <link rel="canonical" href="<?php echo htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8'); ?>" />
  <?php endif; ?>
  <?php foreach ($config['css'] as $css): ?>
  <link href="<?php echo $css; ?>" rel="stylesheet" />
  <?php endforeach; ?>
  <?php if (!empty($inject['header'])): ?>
  <?php echo $inject['header']; ?>
  <?php endif; ?>
  <script type="application/ld+json"><?php echo json_encode($ldJson, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES); ?></script>
</head>
<body class="bg-blue-100 text-gray-900 pt-8">
  <div class="min-h-screen flex justify-center items-start px-4 py-8">
    <div class="bg-gray-50 container max-w-<?php echo $config['settings']['container_max_width'] ?? '4xl'; ?> rounded-md shadow-lg p-8">
      <nav class="mb-6">
        <a href="./about-us.html" class="text-blue-700 hover:underline">About Us</a>
      </nav>
      <h1 class="text-4xl font-bold mb-6"><?php echo htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8'); ?></h1>
